using System;

public class Fraction
{
	private int numerator;
	private int denominator;

	// Tworzy uamek na podstawie podanego
	// licznika i mianownika
	public Fraction(int numerator, int denominator)
	{
		this.numerator = numerator;
		this.denominator = denominator;
	}

	// Przeciony operator + przyjmuje dwa uamki
	// i zwraca ich sum
	public static Fraction operator +(Fraction lhs, Fraction rhs)
	{
		// Uamki o wsplnym mianowniku mona dodawa
		// dodajc ich liczniki
		if (lhs.denominator == rhs.denominator)
		{
			return new Fraction(lhs.numerator + rhs.numerator,
			lhs.denominator);
		}

		// Uproszczone rozwizania dla uamkw o rnych mianownikach
		// 1/2 + 3/4 == (1*4) + (3*2) / (2*4) == 10/8.
		// Ta technika nie przeprowadza redukcji
		int firstProduct = lhs.numerator * rhs.denominator;
		int secondProduct = rhs.numerator * lhs.denominator;
		return new Fraction(
		   firstProduct + secondProduct,
		   lhs.denominator * rhs.denominator
		   );
	}

	// Sprawdza, czy dwa obiekty klasy Fraction s sobie rwne
	public static bool operator ==(Fraction lhs, Fraction rhs)
	{
		if (lhs.denominator == rhs.denominator &&
		lhs.numerator == rhs.numerator)
		{
			return true;
		}
		// Kod do obsugi uamkw o rnych mianownikach
		return false;
	}
	// Delegowanie do operatora == 
	public static bool operator !=(Fraction lhs, Fraction rhs)
	{
		bool equality = lhs == rhs;
		return !(equality);
	}

	// Sprawdza, czy obiekty maj ten sam typ, nastpnie deleguje porwnanie
	public override bool Equals(object o)
	{
		if (!(o is Fraction))
		{
			return false;
		}
		return this == (Fraction)o;
	}
	// Zwraca acuchow reprezentacj uamkw
	public override string ToString()
	{
		String s = numerator.ToString() + "/" +
		denominator.ToString();
		return s;
	}
}


public class Tester
{
	public void Run()
	{
		Fraction f1 = new Fraction(3, 4);
		Console.WriteLine("f1: {0}", f1.ToString());

		Fraction f2 = new Fraction(2, 4);
		Console.WriteLine("f2: {0}", f2.ToString());

		Fraction f3 = f1 + f2;
		Console.WriteLine("f1 + f2 = f3: {0}", f3.ToString());

		Fraction f4 = new Fraction(5, 4);
		if (f4 == f3)
		{
			Console.WriteLine("f4: {0} == F3: {1}",
			f4.ToString(),
			f3.ToString());
		}

		if (f4 != f2)
		{
			Console.WriteLine("f4: {0} != F2: {1}",
			f4.ToString(),
			f2.ToString());
		}

		if (f4.Equals(f3))
		{
			Console.WriteLine("{0}.Equals({1})",
			f4.ToString(),
			f3.ToString());
		}

	}
	static void Main()
	{
		Tester t = new Tester();
		t.Run();
	}
}
